/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.swing;

import edu.princeton.swing.ClipboardTarget;
import edu.princeton.swing.ClipboardTargetManager;
import edu.princeton.swing.DefaultPropertiedListSelectionModel;
import edu.princeton.swing.PropertiedListSelectionModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class PList
extends JList
implements ClipboardTarget {
    private static final Border EMPTY_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final Toolkit TOOLKIT = Toolkit.getDefaultToolkit();
    private JPopupMenu popupMenu;
    private Vector actionListeners;
    private String actionCommand;
    private Listener listener;
    protected Border focusedCellBorder;

    public PList() {
        this.initList();
    }

    public PList(ListModel dataModel) {
        super(dataModel);
        this.initList();
    }

    public PList(Object[] listData) {
        super(listData);
        this.initList();
    }

    public PList(Vector listData) {
        super(listData);
        this.initList();
    }

    private void initList() {
        this.listener = new Listener();
        PropertiedListSelectionModel model = (PropertiedListSelectionModel)this.getSelectionModel();
        model.addPropertyChangeListener(this.listener);
        this.popupMenu = ClipboardTargetManager.createDefaultPopupMenu();
        this.setCellRenderer(new PListCellRenderer());
        this.actionListeners = new Vector();
        this.actionCommand = null;
        ClipboardTargetManager.installMappings(this);
        this.enableEvents(20L);
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.actionListeners.add(listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.actionListeners.remove(listener);
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String actionCommand) {
        if (!(this.actionCommand == actionCommand || actionCommand == null && actionCommand.equals(this.actionCommand))) {
            String oldValue = this.actionCommand;
            this.actionCommand = actionCommand;
            this.firePropertyChange("actionCommand", oldValue, actionCommand);
        }
    }

    @Override
    public boolean canCut() {
        return false;
    }

    @Override
    public void cut() {
    }

    @Override
    public boolean canCopy() {
        return this.isEnabled();
    }

    @Override
    public void copy() {
        if (this.isEnabled()) {
            Object[] values = this.getSelectedValues();
            int length = values.length;
            if (length == 0) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            for (int ctr = 0; ctr < length; ++ctr) {
                buffer.append(values[ctr]);
                if (ctr + 1 >= length) continue;
                buffer.append('\n');
            }
            try {
                Clipboard clipboard = TOOLKIT.getSystemClipboard();
                StringSelection selection = new StringSelection(buffer.toString());
                clipboard.setContents(selection, selection);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean canPaste() {
        return false;
    }

    @Override
    public void paste() {
    }

    @Override
    public boolean canSelectAll() {
        return this.isEnabled() && this.getSelectionMode() != 0;
    }

    @Override
    public void selectAll() {
        if (this.isEnabled() && this.getSelectionMode() != 0) {
            this.setSelectionInterval(0, this.getModel().getSize() - 1);
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1004) {
            ClipboardTargetManager.targetGainedFocus(this);
        } else if (e.getID() == 1005) {
            ClipboardTargetManager.targetLostFocus(this);
        }
        super.processFocusEvent(e);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        boolean passedToSuper = false;
        if (this.popupMenu != null && e.isPopupTrigger()) {
            if (!this.hasFocus()) {
                this.requestFocus();
            }
            int x = e.getX();
            int y = e.getY();
            Point componentLocation = this.getLocationOnScreen();
            Dimension screenSize = TOOLKIT.getScreenSize();
            Dimension preferredSize = this.popupMenu.getPreferredSize();
            if (componentLocation.x + x + preferredSize.width > screenSize.width) {
                x -= preferredSize.width;
            }
            if (componentLocation.y + y + preferredSize.height > screenSize.height) {
                y -= preferredSize.height;
            }
            e.consume();
            passedToSuper = true;
            super.processMouseEvent(e);
            this.popupMenu.show(this, x, y);
        } else if (e.getID() == 500 && e.getClickCount() == 2 && (e.getModifiers() & 0x10) != 0) {
            String actionCommand = this.actionCommand;
            if (actionCommand == null) {
                Object value = this.getSelectedValue();
                actionCommand = value == null ? "" : value.toString();
            }
            ActionEvent actionEvent = new ActionEvent(this, 1001, actionCommand);
            Object[] array = this.actionListeners.toArray();
            for (int ctr = 0; ctr < array.length; ++ctr) {
                ((ActionListener)array[ctr]).actionPerformed(actionEvent);
            }
        }
        if (!passedToSuper) {
            super.processMouseEvent(e);
        }
    }

    @Override
    public void setSelectionBackground(Color selectionBackground) {
        this.focusedCellBorder = new LineBorder(selectionBackground.darker(), 1);
        super.setSelectionBackground(selectionBackground);
        ClipboardTargetManager.targetAbilityChanged(this);
    }

    public Border getFocusedCellBorder() {
        return this.focusedCellBorder;
    }

    public Border getUnfocusedCellBorder() {
        return EMPTY_BORDER;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        ClipboardTargetManager.targetAbilityChanged(this);
    }

    @Override
    public void setSelectionModel(ListSelectionModel selectionModel) {
        if (!(selectionModel instanceof PropertiedListSelectionModel)) {
            throw new IllegalArgumentException();
        }
        PropertiedListSelectionModel model = (PropertiedListSelectionModel)this.getSelectionModel();
        model.removePropertyChangeListener(this.listener);
        super.setSelectionModel(selectionModel);
        model = (PropertiedListSelectionModel)this.getSelectionModel();
        model.addPropertyChangeListener(this.listener);
    }

    @Override
    protected ListSelectionModel createSelectionModel() {
        return new DefaultPropertiedListSelectionModel();
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        if (popupMenu != this.popupMenu) {
            if (popupMenu != null && this.popupMenu.isVisible()) {
                this.popupMenu.setVisible(false);
            }
            JPopupMenu oldValue = this.popupMenu;
            this.popupMenu = popupMenu;
            this.firePropertyChange("popupMenu", oldValue, popupMenu);
        }
    }

    protected static class PListCellRenderer
    extends DefaultListCellRenderer {
        protected PListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (list instanceof PList) {
                if (cellHasFocus) {
                    this.setBorder(((PList)list).getFocusedCellBorder());
                } else {
                    this.setBorder(((PList)list).getUnfocusedCellBorder());
                }
            } else if (cellHasFocus) {
                this.setBorder(UIManager.getBorder("List.focusCellHighlightBorder"));
            } else {
                this.setBorder(EMPTY_BORDER);
            }
            return comp;
        }
    }

    protected class Listener
    implements PropertyChangeListener {
        protected Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("selectionMode".equals(e.getPropertyName())) {
                ClipboardTargetManager.targetAbilityChanged(PList.this);
            }
        }
    }
}

